define([
    'underscore',
    'backbone',
    'Layout',
    'modules/appointments/requested/requested-appointment-provider-preferences-view',
],
function (
    _,
    Backbone,
    Layout,
    RequestedAppointmentView
) {
    'use strict';
    describe('Preferred Providers', function () {
        var view;
        var layout = new Layout();
        var model;
        layout.render();
        describe('address', function() {
            beforeEach(function () {
                model = new Backbone.Model({
                    preferredProviders: [
                        {
                            address: {
                                street: '1234 some street',
                                city: 'city',
                                state: 'state',
                                zipCode: '12345 1234',
                            },
                        },
                        {
                            address: {
                                street: '1234 some street',
                                state: 'state',
                                zipCode: '12345 1234',
                            },
                        },
                        {
                            address: {
                                street: '1234 some street',
                                city: 'city',
                                zipCode: '12345 1234',
                            },
                        },
                        {
                            address: {},
                        },
                    ],
                });
                view = new RequestedAppointmentView({model: model});
                view.setDisplayString();
            });
            it('has a full address', function() {
                expect(view.model.get('preferredProviders')[0].addressString).toEqual('1234 some street, city state, 12345 1234');
            });
            it('has only a state', function() {
                expect(view.model.get('preferredProviders')[1].addressString).toEqual('1234 some street, state, 12345 1234');
            });
            it('has only a city', function() {
                expect(view.model.get('preferredProviders')[2].addressString).toEqual('1234 some street, city, 12345 1234');
            });
            it('has nothing', function() {
                expect(view.model.get('preferredProviders')[3].addressString).toEqual('');
            });
        });

        describe('setNameString', function() {
            beforeEach(function () {
                model = new Backbone.Model({
                    preferredProviders: [
                        {
                            firstName: 'First',
                            lastName: 'Last',
                            practiceName: 'Practice',
                        },
                        {
                            firstName: 'first',
                            addressString: '1234 some street, city state, 12345 1234',
                        },
                        {
                            lastName: 'last',
                            practiceName: 'Practice',
                        },
                        {

                        },
                    ],
                });
                spyOn(RequestedAppointmentView.prototype, 'initialize').and.callFake(_.noop);
                spyOn(RequestedAppointmentView.prototype, 'setDisplayString').and.callFake(_.noop);
                spyOn(RequestedAppointmentView.prototype, 'setAddressString').and.callFake(_.noop);
                view = new RequestedAppointmentView({model: model});
                _.each(model.get('preferredProviders'), function(provider) {
                    view.setNameString(provider);
                });
            });


            it('has a full name', function() {
                expect(model.get('preferredProviders')[0].name).toEqual('First Last');
                expect(model.get('preferredProviders')[0].display).toEqual('First Last,<br>Practice');
            });

            it('has a first name', function() {
                expect(model.get('preferredProviders')[1].name).toEqual('first');
                expect(model.get('preferredProviders')[1].display).toEqual('first,<br>1234 some street, city state, 12345 1234');
            });

            it('has a last name', function() {
                expect(model.get('preferredProviders')[2].name).toEqual('last');
                expect(model.get('preferredProviders')[2].display).toEqual('last,<br>Practice');
            });
            it('is empty', function() {
                expect(model.get('preferredProviders')[3].name).toEqual('');
                expect(model.get('preferredProviders')[3].display).toEqual('');
            });
        });
    });
});
